#include "callback.h"

static int callbackThread(SceSize args, void *argp);
static int exitCallback(int arg1, int arg2, void *common);

int setupExitCallback()
{
    int threadID = 0;

    threadID = sceKernelCreateThread("Callback Update Thread", callbackThread, 0x11, 0xFA0, THREAD_ATTR_USER, 0);

    if (threadID >= 0)
    { sceKernelStartThread(threadID, 0, 0); }

    return threadID;
}

static int callbackThread(SceSize args, void *argp)
{
    int callbackID;

    callbackID = sceKernelCreateCallback("Exit Callback", exitCallback, NULL);
    sceKernelRegisterExitCallback(callbackID);

    sceKernelSleepThreadCB();

    return 0;
}

static int exitCallback(int arg1, int arg2, void *common)
{
    // May do some cleaning up first
    die(NULL);

    return 0;
}

// Like in Perl
void die(char *fmt, ...)
{
    if (fmt != NULL && strlen(fmt) > 0)
    {
        char errmsg[512];
        va_list args;
        va_start(args, fmt);
        vsprintf(errmsg, fmt, args);
        va_end(args);

        strcat(errmsg, "\n\nDying...\n");

        /*
        pspDebugScreenInit();
        pspDebugScreenSetXY(0, 0);
        pspDebugScreenPrintf(errmsg);
        sceKernelSleepThread();
        */

        showMessage(errmsg, 0, messageCallback);
    }

    // Stop video
    sceGuTerm();

    sceKernelExitGame();
}
