#include "mic.h"

int loadMicModules()
{
    int i, returnCode;

    int modules[2] = { PSP_USB_MODULE_ACC, PSP_USB_MODULE_CAM };
    for (i = 0; i < 2; i++)
    {
        returnCode = sceUtilityLoadUsbModule(modules[i]);
        if (returnCode < 0)
        { return returnCode; }
    }

    return 0;
}

int unloadMicModules()
{
    int i, returnCode;

    int modules[2] = { PSP_USB_MODULE_CAM, PSP_USB_MODULE_ACC };
    for (i = 0; i < 2; i++)
    {
        returnCode = sceUtilityUnloadUsbModule(modules[i]);
        if (returnCode < 0)
        { return returnCode; }
    }

    return 0;
}

int startUsb()
{
    int i, returnCode;

    char *drivers[4] = { PSP_USBBUS_DRIVERNAME
                       , PSP_USBACC_DRIVERNAME
                       , PSP_USBCAM_DRIVERNAME
                       , PSP_USBCAMMIC_DRIVERNAME };

    for (i = 0; i < 4; i++)
    {
        returnCode = sceUsbStart(drivers[i], 0, 0);
        if (returnCode < 0)
        { return returnCode; }
    }

    return 0;
}

int stopUsb()
{
    int i, returnCode;

    char *drivers[4] = { PSP_USBCAMMIC_DRIVERNAME
                       , PSP_USBCAM_DRIVERNAME
                       , PSP_USBACC_DRIVERNAME
                       , PSP_USBBUS_DRIVERNAME };

    for (i = 0; i < 4; i++)
    {
        returnCode = sceUsbStop(drivers[i], 0, 0);
        if (returnCode < 0)
        { return returnCode; }
    }

    return 0;
}

int startMic()
{
    return sceUsbActivate(PSP_USBCAM_PID);
}

int stopMic()
{
    return sceUsbDeactivate(PSP_USBCAM_PID);
}
