<?php

# Change these to your own setup

$user = "Nieko";
$mydomain = 'http://www.domain.com/';
$documentroot = '/var/www/domain.com/';

include($documentroot.'shares.data.php'); // import $files

$metric = array('&nbsp;' // nice colors for k, M, G, T
               ,'<span style="color: #900">k</span>'
               ,'<span style="color: #090">M</span>'
               ,'<span style="color: #009">G</span>'
               ,'<span style="color: #990">T</span>');

// Show RSS icon when browsing using PSP
$psp = strstr($_SERVER['HTTP_USER_AGENT'], 'PSP (PlayStation Portable)') !== false;

$results = array();
// Search
if (isset($_GET['search']))
{
    $search = $_GET['search'];
    $results = get_search_results(preg_split('/\s+/', preg_quote($search)), $files, '/');
}
// Show directory
else
{
    /*
     * Sub directory was chosen
     * - Show parent directory
     * - Fetch contents of sub directory
     */
    if (isset($_GET['dir']))
    {
        foreach(explode('/', $_GET['dir']) as $dir)
        { $files = give_dir($dir); }

        if (strstr($_GET['dir'], '/') === false)
        { $link = ''; }
        else
        { $link = '?dir='.urlencode(preg_replace("#/[^/]*$#", '', $_GET['dir'])); }

        $link = "<tr><td></td><td><a href='".$_SERVER['PHP_SELF'].$link."'>..</a></td></tr>\n";
        $results[] = array('name' => '..'
                          ,'type' => 'directory'
                          ,'link' => $link
                          ,'size' => ''
                          );
    }

    $results_dir  = array();
    $results_file = array();
    foreach($files as $file)
    {
        $file_full = isset($_GET['dir']) ? $_GET['dir'].'/'.$file['name'] : $file['name'];
        $extra = 0;
        if (!isset($file['size']))
        { $file['size'] = dirsize($file['contents']); }
        $size_orig = $file['size'];
        while ($file['size'] >= 1024) // Size in kB, MB, GB or TB
        { $file['size'] /= 1024; $extra++; }

        if (isset($file['contents'])) // Directory
        {
            $link = $_SERVER['PHP_SELF']."?".(isset($_GET['dir']) == '' ? "dir=".urlencode($file['name']) : "dir=".urlencode($_GET['dir']."/".$file['name']));
            $link = sprintf("<tr><td align='right'>%.1f%s</td><td><a href='%s'>%s</a>/</td></tr>\n", $file['size'], $metric[$extra], $link, $file['name']);
            $results_dir[] = array('name' => $file_full
                                  ,'type' => 'directory'
                                  ,'link' => $link
                                  ,'size' => $size_orig
                                  );
        }
        else // File
        {
            // PSP can download directly
            $file_link = $psp ? "<a href='".$mydomain.$file_full."'>{$file['name']}</a>" : $file['name'];
            $link = sprintf("<tr><td align='right'>%.1f%s</td><td>%s</td></tr>\n", $file['size'], $metric[$extra], $file_link);
            $results_file[] = array('name' => $file_full
                                   ,'type' => 'directory'
                                   ,'link' => $link
                                   ,'size' => $size_orig
                                   );
        }
    }
    $results = array_merge(array_merge($results, $results_dir), $results_file);
}

if (isset($_GET['rss']))
{
    header('Content-Type: application/xml');
    // Set title and icon
    $url = $mydomain."icon/";
    if (isset($_GET['search']))
    {
        $title = htmlspecialchars("Search: ".$_GET['search']);
        // Select icon
        foreach(preg_split('/\s+/', $_GET['search']) as $adir)
        {
            $search = preg_replace("/\b(?!(de|van|het|t)\b)([a-z])/ie", "ucfirst('\\2')", $adir);
            if (file_exists($documentroot."icon/$search.jpg"))
            { $url = $mydomain.str_replace(' ', '%20', "icon/$search.jpg"); break; }
        }
    }
    else
    {
        $title = htmlspecialchars(preg_replace("#^.*/#", '', (isset($_GET['dir']) ? $_GET['dir'] : 'Root')));
        // Select icon
        foreach(array_reverse(explode('/', (isset($_GET['dir']) ? $_GET['dir'] : 'Root'))) as $adir)
        {
            if (file_exists($documentroot."icon/".preg_replace("/\b(?!(de|van|het|t)\b)([a-z])/ie", "ucfirst('\\2')", $adir).".jpg"))
            { $url = $mydomain.str_replace(' ', '%20', "icon/$adir.jpg"); break; }
        }
    }
    $link = "http://"
           .$_SERVER['SERVER_NAME']
           .$_SERVER['PHP_SELF']
           .(isset($_SERVER['QUERY_STRING']) ? '?'.htmlspecialchars($_SERVER['QUERY_STRING']): '');

    print <<<EOD
<rss version="2.0">
    <channel>
        <title>$title</title> 
        <link>$link</link>
        <description></description>
        <language>en-us</language>
        <image>
            <url>$url</url>
            <title>$title</title>
        </image>

EOD;
    foreach($results as $result)
    {
        if (substr($result['name'], -4) != '.mp3')
        { continue; }
        $file_base = preg_replace("#^.*/(.+?)\.mp3#", "\\1", $result['name']);
        if (strstr($file_base, ' - ') !== false)
        {
            $author = htmlspecialchars(preg_replace("#^(.*?) - (.*)$#", "\\1", $file_base));
            $title  = htmlspecialchars(preg_replace("#^(.*?) - (.*)$#", "\\2", $file_base));
        }
        else
        {
            $author = '';
            $title = htmlspecialchars($file_base);
        }
        $pubDate = "Sat, 01 Jan 2000 00:00:00 +0000";
        $enclosure = $mydomain.str_replace(' ', '%20', htmlspecialchars($result['name']));
        print <<<EOD
        <item>
            <title>$title</title>
            <description></description>
            <author>$author</author>
            <pubDate>$pubDate</pubDate> 
            <enclosure url="$enclosure" type="audio/mp3" />
        </item>

EOD;
    }
    print <<<EOD
    </channel>
</rss>
EOD;
}
// Show results
else
{
    print <<<EOD
<html>
<head>
    <title>$user's shares</title>
    <style type="text/css">
        body
        {
            font-family: Courier New;
        }
    </style>
</head>
<body>

EOD;

    $counter = 0; // Number of entries
    $size    = 0; // Size of entries
    $extra   = 0; // Power of 1024
    $print   = '';
    $mp3     = false;
    foreach($results as $result)
    {
        if (substr($result['name'], -4) == '.mp3')
        { $mp3 = true; }
        $print .= $result['link'];
        $counter++;
        $size += $result['size'];
    }
    // Print RSS
    if ($mp3)
    {
        $link = "http://"
               .$_SERVER['SERVER_NAME']
               .$_SERVER['PHP_SELF']
               .(isset($_SERVER['QUERY_STRING']) ? '?'.htmlspecialchars($_SERVER['QUERY_STRING'].'&rss'): '?rss');
        print "<br /><a href='$link'><img src='".$mydomain."/icon/rss.gif' width='68' height='22' alt='RSS 2.0' /></a><br />\n";
    }
    print "<br />";
    if (isset($_GET['search']))
    { print "Results for: $search\n"; }
    print "<table>\n";
    print $print;
    print "</table>\n";

    while ($size >= 1024)
    { $size /= 1024; $extra++; }
    if (!isset($_GET['search']))
    { printf("\n<br />\n%d files/directories in total, %.1f%sB.\n", $counter, $size, $metric[$extra]);} 

    print "<br /><br />";
    print "<form method='get' action='{$_SERVER['PHP_SELF']}' />
<input type='text' name='search' ".(isset($_GET['search']) ? "value='{$_GET['search']}' " : '')."/><input type='radio' name='boolean' value='AND' ".((isset($_GET['boolean']) && $_GET['boolean'] != 'OR') || !isset($_GET['boolean']) ? "checked='checked' " : '')."/>And&nbsp;<input type='radio' name='boolean' value='OR' ".(isset($_GET['boolean']) && $_GET['boolean'] == 'OR' ? "checked='checked' " : '')."/>Or&nbsp;<input type='submit' value='Search!' />
</form>
</body>
</html>\n";
}

function get_search_results($search, $files, $dir)
{
    global $metric, $psp;
    $results = array();
    foreach($files as $file)
    {
        $file_full = $dir.$file['name'];
        if (entry_matches($file_full, $search))
        {
            $extra = 0;
            if (!isset($file['size']))
            { $file['size'] = dirsize($file['contents']); }
            $size_orig = $file['size'];
            while ($file['size'] >= 1024)
            { $file['size'] /= 1024; $extra++; }

            $link = '';
            $tempdir = '';
            foreach(explode('/', $dir) as $adir)
            {
                if ($adir != '')
                {
                    $tempdir = ($tempdir == '' ? $adir : "$tempdir/$adir");
                    $link .= "<a href='{$_SERVER['PHP_SELF']}?dir=".urlencode($tempdir)."'>$adir</a>/"; // Make links to directories in entry
                }
            }
            if (isset($file['contents'])) // Directory
            {
                $link .= "<a href='{$_SERVER['PHP_SELF']}?dir=".urlencode(($tempdir == '' ? '' : "$tempdir/")."{$file['name']}")."'>".hilight($search, $file['name'])."</a>";
                $link = sprintf("<tr><td align='right'>%.1f%s</td><td>%s</td></tr>\n", $file['size'], $metric[$extra], $link);
                $results[] = array('name' => $file_full
                                  ,'type' => 'directory'
                                  ,'link' => $link
                                  ,'size' => $size_orig
                                  );
            }
            else // File
            {
                // PSP can download directly
                $file_link = hilight($search, $file['name']);
                $file_link = $psp ? "<a href='".$mydomain."$file_full'>$file_link</a>" : $file_link;
                $link = sprintf("<tr><td align='right'>%.1f%s</td><td>%s%s</td></tr>\n", $file['size'], $metric[$extra], $link, $file_link);
                $results[] = array('name' => $file_full
                                  ,'type' => 'file'
                                  ,'link' => $link
                                  ,'size' => $size_orig
                                  );
            }
        }
        // Recursively go through directories
        if (isset($file['contents']))
        { $results = array_merge($results, get_search_results($search, $file['contents'], $dir.$file['name'].'/')); }
    }
    usort($results, 'cmp');
    return $results;
}

function cmp($a, $b)
{
    return strcmp($a['name'], $b['name']);
}

function hilight($search, $entry)
{
    foreach($search as $word)
    {
        if (preg_match("/\w/", $word))
        { $entry = preg_replace("#(?!</?b>)($word)(?!</?b>)#i", "<b>\\1</b>", $entry); }
    }
    return $entry;
}

function entry_matches($entry, $needles)
{
    $allfound   = true;  // Logic AND
    $somefound  = false; // Logic OR
    $entry_base = preg_replace("#^.*/(.*?)$#", "\\1", $entry);

    foreach($needles as $needle)
    {
        // Never show files with "-" prefix in query
        if (preg_match("/^-/i", $needle))
        {
            $needle = substr($needle, 1); 
            if (preg_match("/$needle/i", $entry))
            { $allfound = false; }
        }
        // Otherwise, ehm, check :)
        else
        {
            if (preg_match("/$needle/i", $entry_base))
            { $somefound = true; $allfound &= true; }
            else
            { $allfound &= false; }
        }
    }
    return $_GET['boolean'] == 'OR' ? $somefound : $allfound;
}

function give_dir($dir)
{
    global $files;
    foreach($files as $file)
    {
        if(isset($file['contents']) && $file['name'] == $dir)
        { return $file['contents']; }
    }
    die("Incorrect directory!\n");
}

function dirsize($dir)
{
    $size = 0;
    foreach($dir as $entry)
    {
        if (isset($entry['contents']))
        { $size += dirsize($entry['contents']); }
        elseif (isset($entry['size']))
        { $size += $entry['size']; }
    }
    return $size;
}

?>
